//
//  SurveySmartphoneUsage05ViewController.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 27.06.23.
//

import Foundation
import UIKit

class SurveySmartphoneUsage05ViewController: UIViewController, UITextFieldDelegate {


    @IBOutlet var homeButton: UIButton!
    
    @IBOutlet var progressBarView: UIProgressView!
    
    @IBOutlet var continueButton: UIButton!
    
    @IBOutlet var logoImage: UIImageView!
    
    @IBOutlet var questionLabel: UILabel!
    
    @IBOutlet var answerTextField: UITextField!
    
    fileprivate var _kbSize:CGSize!

    let numberofQuestions : Int = 10

    let currentQuestionNumber : Int = 5




    override func viewDidLoad() {
        super.viewDidLoad()

        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : Colors.carmine,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        answerTextField.becomeFirstResponder()
        NotificationCenter.default.addObserver(self, selector: #selector(self.keyboardWillShow(_:)), name: UIResponder.keyboardWillShowNotification, object: nil)

        homeButton.backgroundColor = UIColor.clear
        homeButton.setImage(UIImage(systemName: "homeButton"), for: .normal)
        homeButton.tintColor = UIColor.init(red: 169.0/255.0, green: 1/255.0, blue: 25/255.0, alpha: 1.0)

        homeButton.frame.size = CGSize(width: 15, height: 15)
        homeButton.addTarget(self, action: #selector(pressedHomeButton(_ :)), for: .touchUpInside)

        logoImage.alpha = 0.1

        progressBarView.progress = getProgress()

        continueButton.translatesAutoresizingMaskIntoConstraints = false
        continueButton.isEnabled = false
        continueButton.isHidden = true

        questionLabel.font = UIFont(name: "Avenir-Medium", size: 17) ?? UIFont.systemFont(ofSize: 17)

        answerTextField.delegate = self
        answerTextField.addTarget(self, action: #selector(self.textFieldDidChange(textField:)), for: UIControl.Event.editingChanged)

    }

    @objc func textFieldDidChange(textField : UITextField){
        print("here")
        if (answerTextField.text != "")
        {
            continueButton.isEnabled = true
            continueButton.isHidden = false
            Utilities.styleFilledButtonContinueBlue(continueButton)
        }
    }


    @objc func pressedHomeButton(_ sender: UIButton) {
        print("Home Button Pressed")

        let refreshAlert = UIAlertController(title: nil, message: nil, preferredStyle: UIAlertController.Style.alert)

        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.alignment = .left

        let message = "Sind Sie sicher, dass Sie die Umfrage abbrechen wollen?\nAlle bisher eingebenen Antworten gehen verloren."
        let attributedMessage = NSAttributedString(string: message, attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle])

        refreshAlert.setValue(attributedMessage, forKey: "attributedMessage")

        refreshAlert.addAction(UIAlertAction(title: "Umfrage fortsetzen", style: .cancel, handler: { (action: UIAlertAction!) in
              print("Handle Cancel Logic here")

        }))
        if let continueAction = refreshAlert.actions.first(where: { $0.title == "Umfrage fortsetzen" }) {
            continueAction.setValue(Colors.carmine, forKey: "titleTextColor")
    }


        refreshAlert.addAction(UIAlertAction(title: "Abbrechen", style: .default, handler: { (action: UIAlertAction!) in
              print("Handle Ok logic here")

            // reset all answers
            study_SmartphoneUsageuserAnswersPublic = []

            let storyboard = UIStoryboard(name: "Main", bundle: nil)
            let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController

            self.view.window?.rootViewController = tabBarController
            self.view.window?.makeKeyAndVisible()
        }))

        if let cancelAction = refreshAlert.actions.first(where: { $0.title == "Abbrechen" }) {
            cancelAction.setValue(Colors.greyColor, forKey: "titleTextColor")
        }


        present(refreshAlert, animated: true, completion: nil)
    }

    @IBAction func continueButton(_ sender: Any) {
        if (continueButton.isEnabled && answerTextField.text != "") {
            study_SmartphoneUsageuserAnswersPublic.append(answerTextField.text ?? "")

            // print complete array string
            dump(study_SmartphoneUsageuserAnswersPublic)

            let nc = self.storyboard?.instantiateViewController(withIdentifier: "SurveySmartphoneUsage06NC") as! UINavigationController

            nc.modalPresentationStyle = .fullScreen
            nc.modalTransitionStyle = .coverVertical

            present(nc, animated: true)
        } else {
            answerTextField.layer.borderWidth = 1.0
            answerTextField.layer.cornerRadius = 3.5
            answerTextField.layer.borderColor = Colors.carmine.cgColor
        }



    }

    func getProgress() -> Float{
        let progress = Float(currentQuestionNumber) / Float(numberofQuestions)

        return progress
    }





    /*  UIKeyboardWillShowNotification. */
        @objc internal func keyboardWillShow(_ notification : Notification?) -> Void {



            if let info = notification?.userInfo {

                let frameEndUserInfoKey = UIResponder.keyboardFrameEndUserInfoKey

                //  Getting UIKeyboardSize.
                if let kbFrame = info[frameEndUserInfoKey] as? CGRect {

                    let screenSize = UIScreen.main.bounds

                    //Calculating actual keyboard displayed size, keyboard frame may be different when hardware keyboard is attached (Bug ID: #469) (Bug ID: #381)
                    let intersectRect = kbFrame.intersection(screenSize)

                    if intersectRect.isNull {
                        _kbSize = CGSize(width: screenSize.size.width, height: 350) // default keyboard height = 350
                    } else {
                        _kbSize = intersectRect.size
                    }
                    print("Your Keyboard Size \(_kbSize)")
                    print(_kbSize.height)
                    //let rectCG = CGRect(x: 0, y: 0, width: 0, height: _kbSize.height)
                    continueButton.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -(_kbSize.height)-10).isActive = true
                }
            }
        }


}
